% --------------------------------------------------------------
% Compute eigenvalues of 1D Helmholtz equation using FD
% --------------------------------------------------------------
function k = HFD1D(a, N)

% Arguments:
%    a = length of interval
%    N = number of subintervals (equal length)
% Returns:
%    k = eigenvalues

h = a/N;               % Grid size
A = spalloc(N-1, ...   % Allocate sparse matrix 
            N-1, ...   % with 3*(N-1) nonzeros
            3*(N-1)); 
d = -2/h^2;            % Value of diagonal entries
s = 1/h^2;             % Value of upper and lower 
                       % diagonal entries

% Initialize the diagonal entries
for i = 1:N-1
  A(i,i) = d;   % Diagonal entries
end

% Initialize the upper and lower diagonal entries
for i = 1:N-2
  A(i,i+1) = s; % Upper diagonal entries
  A(i+1,i) = s; % Lower diagonal entries
end

% Computing the eigenvalues
lambda = eig(A);        
k = sqrt(sort(-lambda));
